/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameRGBBlink;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.tools.Util;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public final class FrameBitpix
extends FrameRGBBlink {
    private String TITLE;
    private String INFO;
    private String HELP1;
    private String CUT;
    private String CUTLABEL;
    private String CAST;
    private String PLANE;
    private static int[] BITPIX = new int[]{-64, -32, 64, 32, 16, 8};
    private static String[] CODE = new String[]{"double (-64)", "float (-32)", "long (64)", "integer (32)", "short (16)", "byte (8)"};
    private JRadioButton[] rb;
    private JRadioButton cut;
    private JLabel srcSize;
    private JLabel trgSize;
    private ButtonGroup cbBitpix;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("BITPIXTITLE");
        this.INFO = Aladin.chaine.getString("BITPIXINFO");
        this.HELP1 = Aladin.chaine.getString("BITPIXHELP");
        this.CUTLABEL = Aladin.chaine.getString("BITPIXCUTLABEL");
        this.CUT = Aladin.chaine.getString("BITPIXCUT");
        this.CAST = Aladin.chaine.getString("BITPIXCAST");
    }

    protected FrameBitpix(Aladin aladin) {
        super(aladin);
        Aladin.setIcon(this);
    }

    @Override
    protected String getTitre() {
        return this.TITLE;
    }

    @Override
    protected String getInformation() {
        return this.INFO;
    }

    @Override
    protected String getHelp() {
        return this.HELP1;
    }

    @Override
    protected int getToolNumber() {
        return -2;
    }

    @Override
    protected int getNb() {
        return 1;
    }

    @Override
    protected String getLabelSelector(int i) {
        return this.PLANE;
    }

    protected PlanImage[] getPlan() {
        Vector<Plan> v = this.a.calque.getPlans(1);
        if (v == null) {
            return new PlanImage[0];
        }
        Object[] pi = new PlanImage[v.size()];
        v.copyInto(pi);
        return pi;
    }

    @Override
    protected Color getColorLabel(int i) {
        return Color.black;
    }

    @Override
    protected JPanel getAddPanel() {
        JRadioButton cb;
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        c.gridwidth = 0;
        JPanel p = new JPanel();
        p.setLayout(g);
        this.cbBitpix = new ButtonGroup();
        JPanel pp1 = new JPanel();
        JLabel l = new JLabel("Bitpix:");
        l.setFont(l.getFont().deriveFont(1));
        pp1.add(l);
        this.rb = new JRadioButton[BITPIX.length];
        JPanel pbitpix = new JPanel(new GridLayout(2, 3));
        for (int i = 0; i < this.rb.length; ++i) {
            this.rb[i] = cb = new JRadioButton(CODE[i]);
            cb.setActionCommand(CODE[i]);
            pbitpix.add(cb);
            this.cbBitpix.add(cb);
            cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameBitpix.this.updateTrg();
                }
            });
        }
        pp1.add(pbitpix);
        g.setConstraints(pp1, c);
        p.add(pp1);
        ButtonGroup cbg = new ButtonGroup();
        JPanel pp = new JPanel();
        l = new JLabel(this.CUTLABEL);
        l.setFont(l.getFont().deriveFont(1));
        pp.add(l);
        this.cut = cb = new JRadioButton(this.CUT);
        cb.setActionCommand(this.CUT);
        cbg.add(cb);
        pp.add(cb);
        cb.setSelected(true);
        cb = new JRadioButton(this.CAST);
        cb.setActionCommand(this.CAST);
        cbg.add(cb);
        pp.add(cb);
        g.setConstraints(pp, c);
        p.add(pp);
        pp = new JPanel();
        this.srcSize = l = new JLabel(".");
        l.setFont(l.getFont().deriveFont(2));
        pp.add(l);
        g.setConstraints(pp, c);
        p.add(pp);
        pp = new JPanel();
        this.trgSize = l = new JLabel(".");
        l.setFont(l.getFont().deriveFont(2));
        pp.add(l);
        g.setConstraints(pp, c);
        p.add(pp);
        return p;
    }

    @Override
    protected void submit() {
        try {
            PlanImage p = (PlanImage)this.getPlan(this.ch[0]);
            String code = this.cbBitpix.getSelection().getActionCommand();
            int i = Util.indexInArrayOf(code, CODE);
            int fct = this.cut.isSelected() ? 9 : 8;
            this.a.calque.newPlanImageAlgo(null, p, null, fct, 0.0, "" + BITPIX[i], 0);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.error("Bitpix convertion failed !");
        }
    }

    private void updateTrg() {
        PlanImage p = (PlanImage)this.getPlan(this.ch[0]);
        if (p == null) {
            return;
        }
        String code = this.cbBitpix.getSelection().getActionCommand();
        int i = Util.indexInArrayOf(code, CODE);
        int bitpix = BITPIX[i];
        int width = p.naxis1;
        int height = p.naxis2;
        int n = Math.abs(bitpix) / 8;
        long size = (long)width * (long)height * (long)n;
        this.trgSize.setText("Target size: " + width + "x" + height + " x " + n + " => " + Util.getUnitDisk(size));
    }

    private void updateSrc(int bitpix, int width, int height) {
        for (int i = 0; i < BITPIX.length; ++i) {
            this.rb[i].setSelected(BITPIX[i] == bitpix);
            this.rb[i].setEnabled(BITPIX[i] != bitpix);
        }
        int n = Math.abs(bitpix) / 8;
        long size = (long)width * (long)height * (long)n;
        this.srcSize.setText("Current size: " + width + "x" + height + " x " + n + " => " + Util.getUnitDisk(size));
    }

    @Override
    protected void adjustWidgets() {
        this.srcSize.setText("");
        this.trgSize.setText("");
        PlanImage p = (PlanImage)this.getPlan(this.ch[0]);
        if (p == null) {
            return;
        }
        this.updateSrc(p.bitpix, p.naxis1, p.naxis2);
    }
}

